<?php 
header('Expires: Sun, 01 Jan 2014 00:00:00 GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', FALSE);
header('Pragma: no-cache');
session_start();
require_once "db.php";

function getUserIp(){

  // check for shared internet/ISP IP
  if (!empty($_SERVER['HTTP_CLIENT_IP']) && validate_ip($_SERVER['HTTP_CLIENT_IP'])) {
      return $_SERVER['HTTP_CLIENT_IP'];
  }

  // check for IPs passing through proxies
  if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
      // check if multiple ips exist in var
      if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
          $iplist = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
          foreach ($iplist as $ip) {
              if (validate_ip($ip))
                  return $ip;
          }
      } else {
          if (validate_ip($_SERVER['HTTP_X_FORWARDED_FOR']))
              return $_SERVER['HTTP_X_FORWARDED_FOR'];
      }
  }
  if (!empty($_SERVER['HTTP_X_FORWARDED']) && validate_ip($_SERVER['HTTP_X_FORWARDED']))
      return $_SERVER['HTTP_X_FORWARDED'];
  if (!empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) && validate_ip($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']))
      return $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
  if (!empty($_SERVER['HTTP_FORWARDED_FOR']) && validate_ip($_SERVER['HTTP_FORWARDED_FOR']))
      return $_SERVER['HTTP_FORWARDED_FOR'];
  if (!empty($_SERVER['HTTP_FORWARDED']) && validate_ip($_SERVER['HTTP_FORWARDED']))
      return $_SERVER['HTTP_FORWARDED'];

  return $_SERVER['REMOTE_ADDR'];

}

function validate_ip($ip) {
    if (strtolower($ip) === 'unknown')
        return false;

    $ip = ip2long($ip);

    if ($ip !== false && $ip !== -1) {
        $ip = sprintf('%u', $ip);
        if ($ip >= 0 && $ip <= 50331647) return false;
        if ($ip >= 167772160 && $ip <= 184549375) return false;
        if ($ip >= 2130706432 && $ip <= 2147483647) return false;
        if ($ip >= 2851995648 && $ip <= 2852061183) return false;
        if ($ip >= 2886729728 && $ip <= 2887778303) return false;
        if ($ip >= 3221225984 && $ip <= 3221226239) return false;
        if ($ip >= 3232235520 && $ip <= 3232301055) return false;
        if ($ip >= 4294967040) return false;

      }
}


if($_REQUEST['method']!='') {
    
           $Database=new Database();

                $Database->connect();

                $method = $Database->escape_data($_REQUEST['method']);
                
                switch($method){
                    
                    case "addLead":
               
                  $first_name = $Database->escape_data($_REQUEST['first_name']);

                  $last_name  = $Database->escape_data($_REQUEST['last_name']);

                  $address = $Database->escape_data($_REQUEST['address']);

                  $city = $Database->escape_data($_REQUEST['city']);

                   $state = $Database->escape_data($_REQUEST['state']);

                   $zip = $Database->escape_data($_REQUEST['zip']);

                   $phone = $Database->escape_data($_REQUEST['phone']);
                   
                   $dob = $Database->escape_data($_REQUEST['dob']);
                   
                   $jornaya_token = $Database->escape_data($_REQUEST['jornaya_token']);
                   
                   $email = $Database->escape_data($_REQUEST['email']);
                   
                   $ip = getUserIp();
                   
                   $date = date("Y-m-d");
                   
                   

    				$values[0] = $first_name;
                    $values[1] = $last_name;
                    $values[2] = $address;
                    $values[3] = $city;
                    $values[4] = $state;
                    $values[5] = $zip;
                    $values[6] = $phone;
                    $values[7] = $dob;
                    $values[8] = $jornaya_token;
                    $values[9] = $email;
                    $values[10] = $ip;
                    $values[11] = $date;

                $result=$Database->insert("leads_api",$values,'first_name,last_name,address,city,state,zip,phone,dob,jornaya_id,email,ip,datetime');
                
                if($result){
                    $last_id = $Database->getLastId();
                    $response_array = array("message"=>"suceess", "lead_id"=>$last_id);
                  
                }
                else{
                     
                    $response_array = array("message"=>"failure! Please Contact to Administrator");
                }
                  echo json_encode($response_array);
                        
                    break;
                    
                }
                
    
}